/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;

public final class ZipShort
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private final int value;

    public ZipShort(int value2) {
        this.value = value2;
    }

    public ZipShort(byte[] bytes2) {
        this(bytes2, 0);
    }

    public ZipShort(byte[] bytes2, int offset) {
        this.value = ZipShort.getValue(bytes2, offset);
    }

    public byte[] getBytes() {
        byte[] result2 = new byte[]{(byte)(this.value & 0xFF), (byte)((this.value & 0xFF00) >> 8)};
        return result2;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int value2) {
        byte[] result2 = new byte[]{(byte)(value2 & 0xFF), (byte)((value2 & 0xFF00) >> 8)};
        return result2;
    }

    public static int getValue(byte[] bytes2, int offset) {
        int value2 = bytes2[offset + 1] << 8 & 0xFF00;
        return value2 += bytes2[offset] & 0xFF;
    }

    public static int getValue(byte[] bytes2) {
        return ZipShort.getValue(bytes2, 0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o).getValue();
    }

    public int hashCode() {
        return this.value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public String toString() {
        return "ZipShort value: " + this.value;
    }
}

